<?php
/**
 * Plugin Name: GEN Widget Product Context
 * Description: Publishes window.__GEN_WIDGET_PRODUCT_CONTEXT on WooCommerce product pages for GEN widget dynamic answers.
 * Version: 0.1.0
 * Author: Web-intellect
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!function_exists('gen_widget_collect_wc_attributes')) {
    function gen_widget_collect_wc_attributes($product)
    {
        if (!$product || !method_exists($product, 'get_attributes')) {
            return [];
        }

        $result = [];
        $attributes = $product->get_attributes();
        if (!is_array($attributes)) {
            return $result;
        }

        foreach ($attributes as $attribute) {
            if (!is_a($attribute, 'WC_Product_Attribute')) {
                continue;
            }

            $name = $attribute->get_name();
            $label = wc_attribute_label($name);
            $value = '';

            if ($attribute->is_taxonomy()) {
                $terms = wc_get_product_terms($product->get_id(), $name, ['fields' => 'names']);
                if (is_array($terms) && !empty($terms)) {
                    $value = implode(', ', $terms);
                }
            } else {
                $options = $attribute->get_options();
                if (is_array($options) && !empty($options)) {
                    $value = implode(', ', array_map('strval', $options));
                }
            }

            if ($value !== '') {
                $result[$label] = $value;
            }
        }

        return $result;
    }
}

if (!function_exists('gen_widget_clean_text')) {
    function gen_widget_clean_text($value)
    {
        $text = wp_strip_all_tags((string) html_entity_decode((string) $value, ENT_QUOTES | ENT_HTML5, 'UTF-8'));
        return trim((string) preg_replace('/\s+/u', ' ', $text));
    }
}

if (!function_exists('gen_widget_build_price_label')) {
    function gen_widget_build_price_label($product)
    {
        if (!$product || !is_a($product, 'WC_Product')) {
            return '';
        }

        if ($product->is_type('variable') && method_exists($product, 'get_variation_price')) {
            $min = (float) $product->get_variation_price('min', true);
            $max = (float) $product->get_variation_price('max', true);
            if ($min > 0 && $max > 0) {
                $minText = gen_widget_clean_text(wc_price($min));
                $maxText = gen_widget_clean_text(wc_price($max));
                return abs($min - $max) < 0.00001 ? $minText : ($minText . ' - ' . $maxText);
            }
        }

        $price = (float) $product->get_price();
        if ($price > 0) {
            return gen_widget_clean_text(wc_price($price));
        }

        return gen_widget_clean_text($product->get_price_html());
    }
}

if (!function_exists('gen_widget_output_wc_product_context')) {
    function gen_widget_output_wc_product_context()
    {
        if (!function_exists('is_product') || !is_product()) {
            return;
        }

        global $product;
        if (!$product || !is_a($product, 'WC_Product')) {
            return;
        }

        $image_id = $product->get_image_id();
        $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'full') : '';

        $context = [
            'title' => gen_widget_clean_text($product->get_name()),
            'description' => gen_widget_clean_text($product->get_short_description()),
            'image' => $image_url ?: '',
            'price' => gen_widget_build_price_label($product),
            'attrs' => gen_widget_collect_wc_attributes($product),
            'sku' => gen_widget_clean_text($product->get_sku()),
            'url' => get_permalink($product->get_id()),
        ];

        if (!$context['description']) {
            $context['description'] = gen_widget_clean_text($product->get_description());
        }

        $contextJson = wp_json_encode($context, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        echo "<script>(function(){\n";
        echo "var baseContext=" . $contextJson . ";\n";
        echo "var clone=function(v){return JSON.parse(JSON.stringify(v||{}));};\n";
        echo "var cleanText=function(value){var s=String(value||'');s=s.replace(/<[^>]*>/g,' ');s=s.replace(/&nbsp;|&#160;|&thinsp;|&ensp;|&emsp;/gi,' ');s=s.replace(/&amp;/gi,'&').replace(/&quot;/gi,'\"').replace(/&#39;/gi,\"'\").replace(/&lt;/gi,'<').replace(/&gt;/gi,'>');return s.replace(/\\s+/g,' ').trim();};\n";
        echo "var publish=function(ctx){window.__GEN_WIDGET_PRODUCT_CONTEXT=ctx;try{window.dispatchEvent(new CustomEvent('gen-widget-product-context:update',{detail:ctx}));}catch(_e){}};\n";
        echo "var current=clone(baseContext);publish(current);\n";
        echo "var form=document.querySelector('form.variations_form');if(!form){return;}\n";
        echo "var collectSelectedAttrs=function(){var attrs=clone(baseContext.attrs||{});var selects=form.querySelectorAll('.variations select[name^=\"attribute_\"]');selects.forEach(function(select){if(!select){return;}var value=String(select.value||'').trim();if(!value){return;}var row=select.closest('tr');var labelEl=row?row.querySelector('label'):null;var label=cleanText(labelEl?labelEl.textContent:'');if(!label){label=cleanText(select.getAttribute('name')||'').replace(/^attribute_/,'').replace(/^pa_/,'');}var option=select.options[select.selectedIndex];var text=cleanText(option?option.text:value);if(label&&text){attrs[label]=text;}});return attrs;};\n";
        echo "var formatPrice=function(v){var n=Number(v);if(!isFinite(n)){return '';}return new Intl.NumberFormat('ru-RU',{minimumFractionDigits:2,maximumFractionDigits:2}).format(n)+' ₽';};\n";
        echo "var applyVariation=function(variation){if(!variation){return;}var image='';if(variation.image&&variation.image.full_src){image=variation.image.full_src;}else if(variation.image&&variation.image.src){image=variation.image.src;}var price='';if(variation&&variation.display_price!==undefined&&variation.display_price!==null&&variation.display_price!==''){price=formatPrice(variation.display_price);}if(!price){price=cleanText(variation.price_html||'');}var next=clone(baseContext);next.title=cleanText(baseContext.title);next.description=cleanText(variation.variation_description||baseContext.description);next.image=image||baseContext.image||'';next.price=price||baseContext.price||'';next.attrs=collectSelectedAttrs();next.sku=cleanText(variation.sku||baseContext.sku);next.url=cleanText(variation.permalink||baseContext.url);current=next;publish(current);};\n";
        echo "var resetContext=function(){current=clone(baseContext);publish(current);};\n";
        echo "if(window.jQuery){var \$f=window.jQuery(form);\$f.on('found_variation',function(_e,variation){applyVariation(variation);});\$f.on('reset_data hide_variation',function(){resetContext();});\$f.on('woocommerce_variation_has_changed',function(){var attrs=collectSelectedAttrs();current=clone(current);current.attrs=attrs;publish(current);});}\n";
        echo "form.addEventListener('reset',resetContext);\n";
        echo "})();</script>\n";
    }
}

add_action('wp_footer', 'gen_widget_output_wc_product_context', 20);
